rule Win32_Ransomware_DMALocker : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "DMALOCKER"
        description         = "Yara rule that detects DMALocker ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "DMALocker"
        tc_detection_factor = 5

    strings:

        $dmalock_v1_encrypt_files_1 = {
            83 C4 ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8D 95 ?? ?? 
            ?? ?? A3 ?? ?? ?? ?? 52 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 
            F8 ?? 75 ?? 32 C0 5F 5E 5B 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8A 9D ?? ?? ?? 
            ?? 33 C0 84 DB 74 ?? EB ?? 8D [2-5] 8A 90 ?? ?? ?? ?? 84 D2 74 ?? 8A 8C 05 
            ?? ?? ?? ?? 3A CA 74 ?? 80 F1 ?? 3A CA 75 ?? 40 80 BC 05 ?? ?? ?? ?? ?? 75 ?? 8A 8C 
            05 ?? ?? ?? ?? 3A 88 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 33 C0 84 DB 74 ?? 8A 90 ?? ?? ?? 
            ?? 84 D2 74 ?? 8A 8C 05 ?? ?? ?? ?? 3A CA 
        }

        $dmalock_v1_encrypt_files_2 = {
            EB ?? 8D 8D ?? ?? ?? ?? 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B BD ?? ?? ?? ?? 
            8D 95 ?? ?? ?? ?? 52 57 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? 
            ?? 8B 4D ?? 5F 5E 33 CD B0 ?? 5B E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

        $dmalock_v1_encrypt_files_3 = {
            74 ?? 80 F1 ?? 3A CA 75 ?? 40 80 BC 05 ?? ?? ?? ?? ?? 75 ?? 8A 8C 05 ?? ?? ?? ?? 3A 
            88 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 56 8D 95 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? 52 E8 ?? ?? ?? ?? 8A 85 ?? ?? ?? ?? 83 C4 ?? A8 ?? 74 ?? A8 ?? 0F 85 ?? ?? ?? 
            ?? 8D 85 ?? ?? ?? ?? 50 56 8D 8D ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 8B 55 
            ?? 8B 85 ?? ?? ?? ?? 52 50 8D 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4
        }

        $dmalock_v1_enum_shares_and_discs_type_1 = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 45 ?? 53 56 57 68 ?? ?? 
            ?? ?? 50 89 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B ?? 83 C4 ?? 89 ?? ?? ?? ?? ?? C6 85 ?? 
            ?? ?? ?? ?? 85 ?? 0F 84 ?? ?? ?? ?? ?? 32 DB E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? ?? 
            8B F8 E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 ?? 6A ?? 89 45 ?? 66 89 45 ?? 88 45 ?? 8D 45 ?? 
            6A ?? 50 88 5D ?? E8 ?? ?? ?? ?? 6A ?? 8D 4D ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 
            C4 ?? 85 C0 75 ?? B3 ?? 6A ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 84 DB 74 ?? ?? E8 ?? ?? 
            ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 32 C0 5F 5E 5B 8B 4D ?? 33 CD 
            E8 ?? ?? ?? ?? 8B E5 5D C3 8D 95 ?? ?? ?? ?? 52 ?? E8 ?? ?? ?? ?? 83 C4 ?? 50 E8 ?? 
            ?? ?? ?? 83 C4 ?? 83 BD ?? ?? ?? ?? ?? 77 ?? 81 BD ?? ?? ?? ?? ?? ?? ?? ?? 72 ?? C6 
            85 ?? ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 ?? E8 ?? ?? ?? ?? 83 C4 ?? 50 E8 ?? ?? ?? ?? 
            8B 8D ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 51 52 68
        }

        $dmalock_v1_enum_shares_and_discs_type_2 = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 45 ?? 53 8B 5D ?? 56 57 
            8D 8D ?? ?? ?? ?? 51 50 6A ?? 6A ?? 6A ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? 
            ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 
            C4 ?? 33 C0 5F 5E 5B 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 ?? ?? 8B 95 ?? ?? ?? 
            ?? 52 6A ?? FF 15 ?? ?? ?? ?? 8B F8 89 BD ?? ?? ?? ?? 85 FF 75 ?? 50 68 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 5F 5E 5B 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 ?? 
            ?? 8D A4 24 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 6A ?? 57 E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? 
            ?? 83 C4 ?? 8D 8D ?? ?? ?? ?? 51 57 8D 95 ?? ?? ?? ?? 52 50 FF 15 ?? ?? ?? ?? 85 C0 
            0F 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 39 85 ?? ?? ?? ?? 76 ?? 8D 77 ?? EB ?? 8D A4 24 
            ?? ?? ?? ?? 83 7E ?? ?? 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 6A ?? 51 
            C6 85 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 0E 8B C1 83 C4 ?? 8D 78 ?? 8B FF 8A 10 40 84 
            D2 75 ?? 2B C7 50 51 8D 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8B 06 83 C4 ?? 8D 50 ?? 90 
            8A 08 40 84 C9 75 ?? 2B C2 6A ?? 8D 84 05 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? 
            ?? 8B 4D ?? 83 C4 ?? 51 8D 95 ?? ?? ?? ?? 53 52 E8 ?? ?? ?? ?? 8B BD ?? ?? ?? ?? 83 
            C4 ?? 8B 46 ?? 83 E0 ?? 3C ?? 75 ?? 8B 4D ?? 51 53 8D 56 ?? 52 E8 ?? ?? ?? ?? 85 C0 
            75 ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B 85 ?? ?? ?? ?? 40 83 C6 ?? 89 85 ?? 
            ?? ?? ?? 3B 85 ?? ?? ?? ?? 0F 82 ?? ?? ?? ?? E9 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 ?? 50 
            68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 57 FF 15 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 FF 
            15 ?? ?? ?? ?? 8B 4D ?? F7 D8 5F 1B C0 5E 33 CD 40 5B E8 ?? ?? ?? ?? 8B E5 5D C2
        }

        $dmalock_v1_enum_shares_and_discs_type_3 = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 45 ?? 53 56 57 68 ?? ?? 
            ?? ?? 89 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? A3 ?? ?? ?? ?? FF D0 68 ?? ?? ?? ?? 
            8D 8D ?? ?? ?? ?? 6A ?? 51 8B D8 C6 85 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? A3 ?? ?? ?? ?? BF ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? 
            ?? ?? ?? F7 C3 ?? ?? ?? ?? 76 ?? 57 8D 95 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? 
            ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 8B F0 56 68 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 83 FE ?? 74 ?? 83 FE ?? 74 ?? 83 FE ?? 75 ?? 8B 
            55 ?? 8B 85 ?? ?? ?? ?? 52 50 8D 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 47 D1 EB 
            FF 8D ?? ?? ?? ?? 75 ?? 8B 4D ?? 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

        $dmalock_v2_enum_logical_disks = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 53 33 DB 68 ?? ?? ?? ?? 8D 
            85 ?? ?? ?? ?? 53 50 88 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F BE 4D ?? 51 8D 95 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 53 50 88 9D ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 8D 95 ?? ?? ?? 
            ?? 52 FF 15 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 
            85 C0 75 ?? 8D 8D ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 ?? 
            B0 ?? 5B 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8B 4D ?? 8A C3 33 CD 5B E8 ?? ?? 
            ?? ?? 8B E5 5D C3 
        }

        $dmalock_v4_remote_server_communication = {
            85 FF 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 83 FB ?? 0F 
            87 ?? ?? ?? ?? FF 24 9D ?? ?? ?? ?? 8B 46 ?? 50 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 
            C4 ?? B0 ?? C3 8B 4E ?? 8B 56 ?? 51 52 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? B0 
            ?? C3 8B 46 ?? 8B 4E ?? 50 51 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? B0 ?? C3 8B 
            56 ?? 8B 46 ?? 52 50 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? B0 ?? C3 8B 4E ?? 8B 
            56 ?? 51 52 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? B0 ?? C3 8B 46 ?? 8B 4E ?? 8B 
            56 ?? 50 51 52 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? B0 ?? C3 8B 46 ?? 8B 4E ?? 
            50 51 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? B0 ?? C3 32 C0 C3 
        }

        $dmalock_v4_encrypt_file_1 = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 45 ?? 53 56 57 68 ?? ?? 
            ?? ?? 50 89 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 83 C4 ?? 85 F6 0F 84 ?? ?? ?? ?? 56 
            32 DB E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 56 8B F8 E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 56 
            6A ?? 89 45 ?? 89 45 ?? 66 89 45 ?? 8D 45 ?? 6A ?? 50 88 5D ?? E8 ?? ?? ?? ?? 6A ?? 
            8D 4D ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? B3 ?? 6A ?? 57 56 E8 
            ?? ?? ?? ?? 83 C4 ?? 84 DB 74 ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 5F 5E 5B 8B 4D ?? 
            33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

        $dmalock_v4_encrypt_file_2 = {
            68 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 6A ?? 52 C6 85 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 
            ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F0 83 C4 ?? 89 B5 ?? ?? ?? 
            ?? 85 F6 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8B 
            D8 6A ?? 53 E8 ?? ?? ?? ?? 83 C4 ?? 83 3D ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? 
            ?? 0F 85 ?? ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 8B F0 83 C4 ?? 89 B5 ?? ?? ?? ?? 85 F6 74 
            ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 89 46 ?? 85 C0 74 ?? 8B 75 ?? B9 ?? ?? ?? 
            ?? 8B F8 F3 A5 66 A5 8B B5 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 89 46 
            ?? EB ?? 33 F6 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8D 7E ?? 57 89 35 ?? ?? ?? ?? FF 15 
            ?? ?? ?? ?? 85 C0 74 ?? 6A ?? 8B C6 E8 ?? ?? ?? ?? 84 C0 74 ?? 8B 4E ?? 8B 17 56 6A 
            ?? 6A ?? 68 ?? ?? ?? ?? 51 52 FF 15 ?? ?? ?? ?? 85 C0 74 ?? C6 46 ?? ?? 8B B5 ?? ?? 
            ?? ?? 8D 85 ?? ?? ?? ?? 50 53 8D 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 56 6A ?? 6A ?? 68 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 56 52 6A ?? 53 E8 ?? ?? ?? ?? 8B 45 ?? 
            8B 8D ?? ?? ?? ?? 56 50 6A ?? 51 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 ?? E8 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8B 4D ?? 5F 5E 33 
            CD B8 ?? ?? ?? ?? 5B E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

    condition:
        uint16(0) == 0x5A4D and ($dmalock_v1_encrypt_files_1 and $dmalock_v1_encrypt_files_2 and $dmalock_v1_encrypt_files_3 and $dmalock_v1_enum_shares_and_discs_type_1) or
        ($dmalock_v1_encrypt_files_1 and $dmalock_v1_encrypt_files_2 and $dmalock_v1_encrypt_files_3 and $dmalock_v1_enum_shares_and_discs_type_2) or
        ($dmalock_v1_encrypt_files_1 and $dmalock_v1_encrypt_files_2 and $dmalock_v1_encrypt_files_3 and $dmalock_v1_enum_shares_and_discs_type_3) or
        ($dmalock_v1_encrypt_files_1 and $dmalock_v1_encrypt_files_3 and $dmalock_v1_enum_shares_and_discs_type_1 and $dmalock_v2_enum_logical_disks) or
        ($dmalock_v4_encrypt_file_1 and $dmalock_v4_encrypt_file_2 and $dmalock_v4_remote_server_communication and $dmalock_v2_enum_logical_disks)
}